
import { neon } from '@neondatabase/serverless';

if (!process.env.DATABASE_URL) {
    console.error('DATABASE_URL is not set.');
    process.exit(1);
}

const sql = neon(process.env.DATABASE_URL);

async function checkColumns() {
    try {
        const columns = await sql`
      SELECT column_name 
      FROM information_schema.columns 
      WHERE table_name = 'users'
    `;
        console.log('Columns in users table:');
        columns.forEach(col => console.log(`- ${col.column_name}`));

        const hasGenerations = columns.some(c => c.column_name === 'generations_remaining');
        console.log(`\nHas 'generations_remaining'? ${hasGenerations}`);
    } catch (err) {
        console.error(err);
    }
}

checkColumns();
